// Folgende Zeile vor </body> einfuegen:
// <script language="JavaScript1.3">init ();</script>

var
    MENUE= 'men'		// Prefix fuer Menueidentifikation innerhalb von HTML
  , SUBMENUE= 'submen'	// Prefix fuer Submenueidentifikation innerhalb HTML Layer
  , BILD= 'bild'		// Prefix fr Icons der Rubrikennavigation im Seitenkopf
  , TIMEOUT= 100		// Zeitspanne in ms bei MouseOver bis Menue deaktiviert wird
  , LIGHT= '#6699ff'	// Aktivierte Submenuezeile innerhalb HTML Layer
  , DIM= '#99ccff'		// Inaktive Submenuezeile innerhalb HTML Layer
;

var
    ns4up= (document.layers) ? 1 : 0	// Netscape Sonderfall LAYER-Tag ab NS 3.03 (PC)
  , ie4up= (document.all) ? 1 : 0		// Internet-Explorer plattformuebergreifend
  , ns6up= (document.getElementById && !document.all) ? 1 : 0	// Netscape ab Version 6 bzw. OPERA
;

var
    active= null	// Welches Menue-Element ist Aktiv (Number)
  , timer= null		// Im Zusammenhang mit TIMEOUT gesetztes Ereignis
;

/* BEGIN Constructor fuer ein Menue in der Rubrikennavigation im Seitenkopf */

function menue_typ (url_dim, url_light, x, y, breite, hoehe, inhalt) {
  this.url_dim= url_dim;	// URL (abs oder rel) zu inaktivem Menuepunkt der Rubrikennavigation im Seitenkopf
  this.url_light= url_light;	// URL (abs oder rel) zu aktivem Menuepunkt der Rubrikennavigation im Seitenkopf
  this.x= x;	// Absolute Position in Pixeln vom linken Seitenrand
  this.y= y;	// Absolute Position in Pixeln vom oberen Seitenrand
  this.breite= breite;	// Breite des Layer-Bereichs in Pixeln
  this.hoehe= hoehe;	// Hoehe des Layer-Bereichs in Pixeln. Cave! Keine Hoehenanpassung bei NS < 6.1
  this.inhalt= inhalt;	// Anker fuer ein Submenue-Element
}

/* ENDE Constructor fuer ein Menue in der Rubrikennavigation im Seitenkopf */

/* BEGIN Constructor fuer eine Submenue-Zeile in der Rubrikennavigation im Seitenkopf */

function submenue_typ (text, url) {
  this.text= text;	// Dargestellter Text des Submenuepunktes
  this.url= url;	// URL (abs oder rel) des Sprungziels ohne Angabe eines TARGET
}

/* ENDE Constructor fuer eine Submenue-Zeile in der Rubrikennavigation im Seitenkopf */

/* BEGIN der Menuedefinition */

/* Lesender Zugriff: opensubpage, submenue, preload, init, showmenue, hidemenue */
/* Uebergeben werden Tupel (Zeile = Menue, Spalte = Submenue) */

var menues= new Array (
// BEGIN einer Rubrik
    new menue_typ ('/images/news.gif', '/images/news_aktiv.gif', 158, 71, 157, 90, new Array (
// BEGIN eines Submenuepunktes
        new submenue_typ ("Section Overview", "/en/news/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Latest News", "/en/news/news/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Press Releases", "/en/news/press_releases/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Image Archive", "/en/service/image_archive/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Announcements and Proposals", "/en/news/information_science_research/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Scientific Prizes - Reports and Portraits", "/en/news/scientific_prizes/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Special Reports", "/en/news/special_reports/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Speeches - Statements", "/en/news/speeches_statements/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Publications", "/en/news/publikationen/")
// ENDE eines Submenuepunktes
    ))
// ENDE einer Rubrik
// BEGIN einer Rubrik
  , new menue_typ ('/images/research_funding.gif', '/images/research_funding_aktiv.gif', 243, 71, 157, 100, new Array (
// BEGIN eines Submenuepunktes
        new submenue_typ ("Section Overview", "/en/research_funding/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Programmes at a Glance", "/en/research_funding/programmes_at_a_glance.html")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Individual Grants Programme", "/en/research_funding/individual_grants_programme/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Promoting Young Researchers", "/en/research_funding/promoting_young_researchers/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Coordinated Programmes", "/en/research_funding/coordinated_programmes/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Scientific Prizes", "/en/research_funding/scientific_prizes/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Funding Scientific Instrumentation and Infrastructure", "/en/research_funding/scientific_instrumentation_and_infrastructure/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Knowledge Transfer", "/en/research_funding/knowledge_transfer/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Funding Initiatives - Project Groups", "/en/research_funding/initiatives_projectgroups/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Scientific Contacts", "/en/research_funding/scientific_contacts/")
// ENDE eines Submenuepunktes
// BEGIN eines Submenuepunktes
      , new submenue_typ ("Forms and Guidelines", "/en/research_funding/forms/")
// ENDE eines Submenuepunktes
    ))
// ENDE einer Rubrik
// BEGIN einer Rubrik
  , new menue_typ ('/images/dfg_profile.gif', '/images/dfg_profile_aktiv.gif', 328, 71, 157, 70, new Array (
        new submenue_typ ("Section Overview", "/en/dfg_profile/")
      , new submenue_typ ("DFG in Brief", "/en/dfg_profile/dfg_in_brief/")
      , new submenue_typ ("Mission", "/en/dfg_profile/mission/")
      , new submenue_typ ("Structure", "/en/dfg_profile/structure/")
      , new submenue_typ ("History", "/en/dfg_profile/history/")
      , new submenue_typ ("Facts and Figures", "/en/dfg_profile/facts_and_figures/")
    ))
// ENDE einer Rubrik
// BEGIN einer Rubrik
  , new menue_typ ('/images/international.gif', '/images/international_aktiv.gif', 413, 71, 157, 100, new Array (
        new submenue_typ ("Section Overview", "/en/international/")
      , new submenue_typ ("Promotion of International Cooperation", "/en/international/international_cooperation/")
      , new submenue_typ ("International Research Policy", "/en/international/international_research_policy/")
      , new submenue_typ ("The DFG and Europe", "/en/international/europe/")
      , new submenue_typ ("International Promotion of Young Researchers", "/en/international/young_researchers/")
      , new submenue_typ ("International Partners and Agreements", "/en/international/partner/")
      , new submenue_typ ("International Representation of the DFG", "/en/international/liaison_office/")

    ))
// ENDE einer Rubrik
// BEGIN einer Rubrik
  , new menue_typ ('/images/research_careers.gif', '/images/research_careers_aktiv.gif', 498, 71, 157, 40, new Array (
        new submenue_typ ("Section Overview", "/en/research_careers/")
      , new submenue_typ ("Promoting Young Researchers at a Glance", "/en/research_careers/promoting_young_researchers/")
      , new submenue_typ ("Career Planning", "/en/research_careers/career_planning/")
      , new submenue_typ ("Forum", "/en/research_careers/forum/")
      , new submenue_typ ("Focus", "/en/research_careers/focus/")
	  , new submenue_typ ("Equal Opportunities", "/en/research_careers/equal_opportunities/")
    ))
// ENDE einer Rubrik
// BEGIN einer Rubrik
  , new menue_typ ('/images/forschung.gif', '/images/forschung_aktiv.gif', 583, 71, 157, 100, new Array (
        new submenue_typ ("blindtext", "about:")
      , new submenue_typ ("blindtext", "about:")
    ))
// ENDE einer Rubrik
);

/* ENDE der Menuedefinition */

/* BEGIN Unterseite ueber Rubrikenauswahl oeffnen */
/* Tupel (i, j) bestimmt, welches Submenue (j) aus welcher Rubrik (i) ausgewaehlt wurde */
/* Das aktuelle Dokument wird durch die im Tupel referenzierte URL ersetzt */

function opensubpage (i, j) {
  if (timer) { clearTimeout (timer); }	// Rubrikenlayer bleibt ausgeklappt
  document.location= menues[i].inhalt[j].url;
}

/* ENDE Unterseite ueber Rubrikenauswahl oeffnen */

/* BEGIN Submenuepunkt wird nach MouseOver-Ereignis aktiviert dargestellt */
/* Tupel (i, j) bestimmt, welches Submenue (j) aus welcher Rubrik (i) ausgewaehlt wurde */
/* Wird nicht fuer Netscape < 6 ausgefuehrt */

function light (i, j) {
var e= SUBMENUE + i + '_' + j;
var d;

  if (timer) { clearTimeout (timer); }	// Rubrikenlayer bleibt ausgeklappt
  if (ie4up) {
    d= document.all[e].style;
    d.backgroundColor= LIGHT;
  }
  else if (ns6up) {
    d= document.getElementById (e).style;
    d.backgroundColor= LIGHT;
  }
}

/* ENDE Submenuepunkt wird nach MouseOver-Ereignis aktiviert dargestellt */

/* BEGIN Submenuepunkt wird nach MouseOut-Ereignis deaktiviert dargestellt */
/* Tupel (i, j) bestimmt, welches Submenue (j) aus welcher Rubrik (i) ausgewaehlt wurde */
/* Wird nicht fuer Netscape < 6 ausgefuehrt */

function dim (i, j) {
var e= SUBMENUE + i + '_' + j;
var d;

  if (timer) { clearTimeout (timer); }	// Rubrikenlayer bleibt ausgeklappt
  if (ie4up) {
    d= document.all[e].style;
    d.backgroundColor= DIM;
  }
  else if (ns6up) {
    d= document.getElementById (e).style;
    d.backgroundColor= DIM;
  }
  preparehide (active); // Falls kein weiterer Submenuepunkt oder Rubrik ausgewaehlt ist, wird die Schliessung des Layers vorbereitet
}

/* ENDE Submenuepunkt wird nach MouseOut-Ereignis deaktiviert dargestellt */

/* BEGIN Submenuepunkte innerhalb eines Layers vorbereiten */
/* (i) bestimmt, welche Rubrik an der Reihe ist */
/* Wird durch init fuer jede Rubrik einmal aufgerufen */
/* Liefert HTML-Text in Tabellenform */

function submenue (i) {
var j, h;

  h= '<table border=0 width='+menues[i].breite+' cellpadding=0 cellspacing=0>';
  for (j= 0; j < menues[i].inhalt.length; j++) {
    h+=
        '<tr>'
      + '<td height=16 bgcolor="#99ccff" width=14 valign="top">'
      + '<img src="/images/pfeil.gif" width=6 height=10 border=0 hspace=4></td>'
      + '<td height=16 bgcolor="#99ccff" width=143'
    ;
    if (ns4up) {
      h+=
          '><a href="'+ menues[i].inhalt[j].url+ '" class="navlink" '
        + 'onmouseover="light('+i+','+j+');" '
        + 'onmouseout="dim('+i+','+j+');">'
        + menues[i].inhalt[j].text
        + '</a>'
      ;
    }
    else if (ie4up || ns6up) {
      h+=
          ' class="navlink" '
        + 'id="'+SUBMENUE+i+'_'+j+'" '
        + 'onmouseover="light('+i+','+j+');" '
        + 'onmouseout="dim('+i+','+j+');" '
        + 'onclick="opensubpage('+i+','+j+');">'
        + menues[i].inhalt[j].text
      ;
    }
    else { h+= '>'; }
    h+= '</td></tr>';
  }
  h+= '</table>';
  return h;
}

/* ENDE Submenuepunkte innerhalb eines Layers vorbereiten */

/* BEGIN aktivierte Rubrikenicons laden */
/* (i) bestimmt, welche Rubrik an der Reihe ist */
/* Wird durch init fuer jede Rubrik einmal aufgerufen */

function preload (i) {
var b, p= eval ('document.' + BILD + i);

  if (p) {
    b= new Image (p.width, p.height);
    b.src= menues[i].url_light;
  }
}

/* ENDE aktivierte Rubrikenicons laden */

/* BEGIN Layer fuer die spaetere Darstellung im aufrufenden HTML-Dokument vorbereiten */
/* Unterscheidung zwischen den Browserversionen ist hier besonders wichtig */

function init () {
var i, h;
var b= new Array ();

  if (ns4up) {
    for (i= 0; i < menues.length; i++) {	// Fuer jedes Menue
      h=
          '<layer '
        + 'name="'+MENUE+i+'" '
        + 'top='+menues[i].y+' '
        + 'left='+menues[i].x+' '
        + 'width='+menues[i].breite+' '
        + 'height='+menues[i].hoehe+' '
        + 'visibility="hide" '
        + 'z-index="10" '
		+ 'bgcolor="'+DIM+'" '
        + '>'
      ;
      h+= submenue (i);	// Submenuepunkte werden als HTML-Text eingefuegt
      h+= '</layer>';
      document.writeln (h);
      preload (i);	// Aktive Rubrikenbilder werden waehrend des renderings geladen
    }
  }
  else if (ie4up || ns6up) {
    for (i= 0; i < menues.length; i++) {
      h=
          '<div '
        + 'id="'+MENUE+i+'" '
        + 'style=" '
        + 'position:absolute; '
        + 'z-index:10; '
		+ 'top:'+menues[i].y+'px; '
        + 'left:'+menues[i].x+'px; '
        + 'width:'+menues[i].breite+'; '
        + 'height:'+menues[i].hoehe+'; '
		+ 'visibility:hidden; '
        + 'background-color:'+DIM+'; '
        + '">'
      ;
      h+= submenue (i);	// Submenuepunkte werden als HTML-Text eingefuegt
      h+= '</div>';
      document.writeln (h);
      preload (i);	// Aktive Rubrikenbilder werden waehrend des renderings geladen
    }
  }
}

/* ENDE Layer fuer die spaetere Darstellung im aufrufenden HTML-Dokument vorbereiten */

/* BEGIN Rubriken-Layer einblenden */
/* (element) ist die Nummer der ausgewaehlten Rubrik */
/* Aufruf erfolgt durch MouseOver innerhalb des HTML-Dokuments */

function showmenue (element) {
var d= eval ('document.' + BILD + element);

  if (timer) { clearTimeout (timer); }	// Rubrikenlayer bleibt ausgeklappt
  if ((active != null) && (active != element)) { hidemenue (active); } // Die alte aktive Rubrik sofort ausblenden
  if (d) { d.src= menues[element].url_light; }	// Das ausgewaehlte Rubrikenicon wird aktiviert dargestellt
  if (ns4up) {
    with (document.layers[MENUE+element]) { visibility= 'show'; }	// Der jeweilige Layer wird sichtbar gemacht
  }
  else if (ie4up) {
    with (document.all[MENUE+element].style) { visibility= 'visible'; }
  }
  else if (ns6up) {
    with (document.getElementById (MENUE+element).style) { visibility= 'visible'; }
  }
  active= element;	// Aktiv ist die ausgewaehlte Rubrik (Numerisch)
}

/* ENDE Rubriken-Layer einblenden */

/* BEGIN Rubriken-Layer ausblenden */
/* (element) ist die Nummer der ausgewaehlten Rubrik */
/* Aufruf erfolgt durch preparehide */

function hidemenue (element) {
var d= eval ('document.' + BILD + element);

  if (d) { d.src= menues[element].url_dim; }	// Das ausgewaehlte Rubrikenicon wird deaktiviert dargestellt
  if (ns4up) {
    with (document.layers[MENUE+element]) { visibility= 'hide'; }	// Der jeweilige Layer wird unsichtbar gemacht
  }
  else if (ie4up) {
    with (document.all[MENUE+element].style) { visibility= 'hidden'; }
  }
  else if (ns6up) {
    with (document.getElementById (MENUE+element).style) { visibility= 'hidden'; }
  }
  active= null;	// Kein Element aktiv bzw. ausgewaehlt
}

/* ENDE Rubriken-Layer ausblenden */

/* BEGIN Vorbereiten der Rubrikenlayerausblendung nach MouseOut */
/* (element) ist die Nummer der ausgewaehlten bzw. aktiven Rubrik */
/* Beim Wechsel zwischen Rubriken wird das Menue um TIMEOUT verzoegert eingeklappt */

function preparehide (element) {
  timer= setTimeout ('hidemenue ('+element+');', TIMEOUT);
}

/* ENDE Vorbereiten der Rubrikenlayerausblendung nach MouseOut */



/* ANFANG Steuerungsscript fr das Organigramm-PopUp */

function OpenOrganigramm() {
	organigramm = window.open('/dfg_im_profil/struktur/geschaeftsstelle/organigramm.html','Orga','width=830,height=630');
}

/* ENDE Steuerungsscript fr das Organigramm-PopUp */
/* ANFANG Steuerungsscript fr das DFG media-PopUp */
function winopen(strSource)
	{
		dfgmedia = window.open(strSource,"dfgmedia","width=638,height=520,location=0,menubar=0,status=0,toolbar=0,scrollbars=0,resizable=0");
		dfgmedia.focus();
}
function checkMediaWindowSize() {
	if ( isIE ) {
		if ( typeof(window.opener) == 'undefined' ) {
			window.resizeTo(638,520);			
		}
	} else if ( window.opener == null ) {
		window.resizeTo(638,486);			
	}
}
/* ENDE Steuerungsscript fr das DFG media-PopUp */
/* ANFANG Steuerungsscript fr das DFG media-FotostreckePopUp */
function winopenfoto(strSource)
	{
		dfgmedia = window.open(strSource,"dfgmedia","width=600,height=549,location=0,menubar=0,status=0,toolbar=0,scrollbars=0,resizable=0");
		dfgmedia.focus();
}
function checkMediaWindowSize() {
	if ( isIE ) {
		if ( typeof(window.opener) == 'undefined' ) {
			window.resizeTo(600,549);			
		}
	} else if ( window.opener == null ) {
		window.resizeTo(600,549);			
	}
}
/* ENDE Steuerungsscript fr das DFG media-FotostreckePopUp */
/* Functions that swaps images. */
function MM_swapImage() { //v3.0
  var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i<(a.length-2);i+=3)
   if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
}
function MM_swapImgRestore() { //v3.0
  var i,x,a=document.MM_sr; for(i=0;a&&i<a.length&&(x=a[i])&&x.oSrc;i++) x.src=x.oSrc;
}

/* Functions that handle preload. */
function MM_preloadImages() { //v3.0
 var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
   var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
   if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function MM_findObj(n, d) { //v4.0
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && document.getElementById) x=document.getElementById(n); return x;
}

// dfg (c) 2008